(function() {
  if (typeof tinymce === 'undefined') return;
  tinymce.PluginManager.add('kupeli_codeplus', function(editor) {
    function insertBlock(lang, code) {
      lang = (lang || 'text').toLowerCase().trim();
      code = (code || '').replace(/&/g,'&amp;').replace(/</g,'&lt;');
      var block = '<div class="kupeli-code-block">'
        + '<div class="code-header"><span class="lang">' + lang.toUpperCase() + '</span>'
        + '<button class="copy-btn">📋 Kopyala</button></div>'
        // YENİ: Satır numaraları için "line-numbers" sınıfı eklendi
        + '<pre class="line-numbers"><code class="language-' + lang + '">' + code + '</code></pre></div>';
      editor.insertContent(block);
    }
    var isV5 = !!(editor.ui && editor.ui.registry);
    if (isV5) {
      editor.ui.registry.addButton('kupeli_codeplus', {
        text: 'Code+',
        icon: 'code',
        onAction: function() {
          editor.windowManager.open({
            title: 'Kod Ekle (Code+)',
            body: { type:'panel', items:[
              { type:'input', name:'lang', label:'Kod Dili (php, js, html, css, yaml, dockerfile, compose, py...)' },
              { type:'textarea', name:'code', label:'Kod' }
            ]},
            buttons: [{type:'cancel', text:'İptal'}, {type:'submit', text:'Ekle', primary:true}],
            onSubmit(api){ const d=api.getData(); insertBlock(d.lang,d.code); api.close(); }
          });
        }
      });
    } else {
      editor.addButton('kupeli_codeplus', {
        text: 'Code+',
        icon: 'code',
        onclick: function() {
          editor.windowManager.open({
            title: 'Kod Ekle (Code+)',
            body: [
              { type:'textbox', name:'lang', label:'Kod Dili (php, js, html, css, yaml, dockerfile, compose, py...)' },
              { type:'textbox', name:'code', label:'Kod', multiline:true, minWidth: 500, minHeight: 300 }
            ],
            onsubmit: function(e){ insertBlock(e.data.lang, e.data.code); }
          });
        }
      });
    }
  });
})();