(function(){
  // Kopyalama fonksiyonu
  function copyText(text, btn){
    if (navigator.clipboard && navigator.clipboard.writeText) {
      navigator.clipboard.writeText(text).then(function(){
        const old = btn.textContent; btn.textContent='✅ Kopyalandı';
        setTimeout(function(){ btn.textContent=old; }, 1500);
      });
    } else {
      const ta = document.createElement('textarea'); ta.value = text; document.body.appendChild(ta);
      ta.select(); document.execCommand('copy'); document.body.removeChild(ta);
      const old = btn.textContent; btn.textContent='✅ Kopyalandı';
      setTimeout(function(){ btn.textContent=old; }, 1500);
    }
  }

  // Kopyala butonlarını başlatan fonksiyon
  function init(root){
    root.querySelectorAll('.kupeli-code-block .copy-btn').forEach(function(btn){
      if (btn.dataset.inited) return; // Zaten başlatıldıysa atla
      btn.dataset.inited='1';
      btn.addEventListener('click', function(){
        const codeEl = btn.closest('.kupeli-code-block').querySelector('code');
        const text = codeEl ? codeEl.innerText : '';
        copyText(text, btn);
      });
    });
  }

  // Sayfa yüklendiğinde bir kez çalıştır
  document.addEventListener('DOMContentLoaded', function(){
    // Prism'i çağır
    if (window.Prism && typeof Prism.highlightAll === 'function') {
      Prism.highlightAll();
    }
    // Kopyala butonlarını başlat
    init(document);
  });
  
  // DÜZELTME: Sonsuz döngüye ve donmaya neden olan MutationObserver kaldırıldı.
  // const mo = new MutationObserver(function(){ init(document); if (window.Prism) Prism.highlightAll(); });
  // mo.observe(document.documentElement, { childList:true, subtree:true });

})();