<?php
/**
 * Plugin Name: Kupeli Code Block+
 * Description: Gutenberg Code+ bloğu ve Klasik editörde Code+ butonu. Prism.js renklendirme, dil etiketi ve kopyala butonu içerir.
 * Version: 5.2
 * Author: Firat Kupeli
 * License: MIT
 * Requires at least: 6.2
 * Tested up to: 6.6
 */

if (!defined('ABSPATH')) exit;

// DÜZELTME: Önbelleği kırmak için sürüm numaraları 5.2'ye yükseltildi.
add_action('init', function() {
    wp_register_style('kupeli-code-style', plugins_url('style.css', __FILE__), [], '5.2');
    wp_register_style('kupeli-prism-css', plugins_url('prism.css', __FILE__), [], '5.2');
    
    wp_register_script('kupeli-prism-js', plugins_url('prism.js', __FILE__), [], '5.2', true);
    
    // ÖN YÜZ: Sadece kopyalama butonu ve tetikleyici
    wp_register_script(
        'kupeli-frontend', 
        plugins_url('frontend.js', __FILE__), 
        [], // Bağımlılığı yok
        '5.2', 
        true
    );
    
    // EDİTÖR: Sadece blok kaydı ve editör içi mantık
    wp_register_script(
        'kupeli-editor-script', 
        plugins_url('edit.js', __FILE__),
        ['wp-blocks', 'wp-components', 'wp-block-editor', 'wp-element', 'wp-i18n'], 
        '5.2',
        true
    );

    register_block_type(__DIR__, [
        'style'           => 'kupeli-code-style',
        'editor_style'    => 'kupeli-code-style',
        'editor_script'   => 'kupeli-editor-script', // Sadece editörde
        'view_script'     => 'kupeli-frontend',      // Sadece ön yüzde
    ]);
});

// Prism + CSS/JS hem editörde hem ön yüzde
add_action('enqueue_block_assets', function() {
    wp_enqueue_style('kupeli-prism-css');
    wp_enqueue_script('kupeli-prism-js');
});

// Klasik editör Code+ butonu (TinyMCE 4/5)
add_filter('mce_external_plugins', function($plugins) {
    $plugins['kupeli_codeplus'] = plugins_url('editor-button.js', __FILE__);
    return $plugins;
});
add_filter('mce_buttons', function($buttons) {
    $buttons[] = 'kupeli_codeplus';
    return $buttons;
});